package main

import (
	"fmt"
	"os"
	"os/exec"
	"strings"
	"time"
)

var (
	debug          bool   = false
	configlocation string = "/var/scopyrclone/"
)

func errorhandler(err error, dir string, date string) {

	if err != nil && dir == "" && date == "" {
		logerror("Error: " + err.Error())
	} else if err != nil && dir != "" && date != "" {
		logerror("Error: " + err.Error() + " in copying" + dir + " to " + "/sophback/" + date + dir)
	} else if err == nil && dir != "" && date != "" {
		logcopysuccesss(dir, date)
	}
}

func logerror(err string) {
	errlogerr := func(err string, err2 error) {
		fmt.Println("\n\nError: Loggingg error failed: " + err2.Error())
		fmt.Println("While Trying to log" + err)
		fmt.Println("This error has not been logged.")
		fmt.Println("The program will now exit.")
	}
	f, err2 := os.OpenFile(configlocation+"error.log", os.O_APPEND|os.O_WRONLY|os.O_CREATE, 0600)
	if err2 != nil {
		errlogerr(err, err2)
		os.Exit(1)
	} else {
		datetime := time.Now().Format("2006-01-02 15:04: ")
		_, err2 = f.WriteString(datetime + err + "\n")
		if err2 != nil {
			errlogerr(err, err2)
			f.Close()
			os.Exit(1)
		}
	}
	f.Close()
	fmt.Println("\n\nAn error has occured please check the log file (/var/scopyrclone/error.log) for more information.")
	fmt.Println("The program will now exit.")
	os.Exit(1)
}

func logcopysuccesss(dir string, date string) {
	f, err := os.OpenFile(configlocation+"backup.log", os.O_APPEND|os.O_WRONLY|os.O_CREATE, 0600)
	errorhandler(err, "", "")
	_, err = f.WriteString("Copied: " + dir + " to " + "/sophback/" + date + dir + "\n")
	errorhandler(err, "", "")
	f.Close()
}

func read_file() ([]string, string) {
	b, err := os.ReadFile(configlocation + "paths.conf")
	errorhandler(err, "", "")
	s := strings.Split(string(b), "\n")
	r := []string{}
	var j string
	remote := ""
	for i := range s {
		j = strings.Split(s[i], "#")[0]
		j = strings.TrimSpace(j)
		if strings.HasPrefix(s[i], "/") {
			r = append(r, j)

		} else if len(j) > 3 && strings.Contains(j, ":/") {
			remote = j
		}
	}
	return r, remote
}

func copydirs(path string, date string, remote string) {

	timebfore := time.Now()
	fmt.Print("\nCopying " + path + "\n")
	exe := exec.Command("rclone", "copy", path, remote)
	err := exe.Run()
	errorhandler(err, path, date)
	//time.Sleep(4 * time.Second)
	fmt.Print("Copied in " + fmt.Sprint(time.Since(timebfore)) + "\n")
}

func main() {
	paths := []string{}
	remote := ""
	if len(os.Args) == 2 {
		if os.Args[1] == "--help" || os.Args[1] == "-h" {
			fmt.Print("\n\nUsage: scopyrclone options\n\n")
			fmt.Print("     Options:\n\n")
			fmt.Print("      [paths]   -   The paths to upload.\n\n")
			fmt.Print("  --help (-h)   -   Display this help message.\n\n\n")
			fmt.Print("                    About:\n\n")
			fmt.Print("                    This is a simple program to upload files to\n")
			fmt.Print("                    a remote server using rclone.\n\n")
			fmt.Print("                    This program is free software: you can\n")
			fmt.Print("                    redistribute it and/or modify.\n\n")
			fmt.Print("                    More information can be found at:\n")
			fmt.Print("                    sophuwu.site/software/scopyrclone\n\n")
			os.Exit(0)
		} else {
			_, remote = read_file()
			paths = []string{os.Args[1]}
		}
	} else if len(os.Args) > 2 && !(os.Args[1] == "--help" || os.Args[1] == "-h") {
		_, remote = read_file()
		paths = os.Args[1:]
	} else {
		paths, remote = read_file()
	}

	if remote == "" {
		logerror("Error: No remote server specified.")
	} else if !strings.Contains(remote, ":/") {
		logerror("Error: Remote server must be in the format remote:/path/to/backup")
	} else if !strings.HasSuffix(remote, "/") {
		remote = remote + "/"
	}

	if len(paths) == 0 {
		logerror("Error: No paths specified.")
	}

	fmt.Print("\n\nStarting backup to " + remote + "\n")
	datetime := time.Now().Format("2006-01-02-15-04")
	time.Sleep(3 * time.Second)
	starttime := time.Now()
	for i := 0; i < len(paths); i++ {
		copydirs(paths[i], datetime, remote)
		fmt.Print(fmt.Sprint(i+1) + "/" + fmt.Sprint(len(paths)) + " Completed.\n")
	}
	fmt.Print("\nBackup complete.\n")
	fmt.Print("Backup took " + fmt.Sprint(time.Since(starttime)) + "\n")
}
