package main

import (
	"encoding/json"
	"fmt"
	"image/color"
	"io/ioutil"
	"net/http"
	"net/url"
	"os"
	"strconv"
	"time"

	"golang.org/x/net/websocket"
	"github.com/AllenDang/giu"
	g "github.com/AllenDang/giu"
)

var (
	user             string = ""
	password         string = ""
	addcontact       string = ""
	sendmessage      string = ""
	sendingto        string = ""
	loginuser        string = ""
	loginpassword    string = ""
	registeruser     string = ""
	registerpassword string = ""
	errormessage     string = ""
	totalpages       int    = 1
	page             int    = 1
	minid			int = 0
	contactList      []string
	messageList      []messagestruc
	wnd              = g.NewMasterWindow(" ", 1, 1, g.MasterWindowFlagsFrameless)
)

const (
	api           string = "https://goapi.sophuwu.site/smessenger"
	versionserver string = "https://api.sophuwu.site/software/version/smessenger"
	updateurl     string = "https://sophuwu.site/smessenger"
	version       string = "1.1"
)

type messagestruc struct {
	Id      int
	Message string
	From    string
	To      string
	Time    string
}

type DynamicWidget struct {
	isHorizontal bool
	hasRows      bool
	getter       dynamicGetterFunc[any]
	builder      DynamicBuilder[any]
}

func DynamicHR[T any](list []T, f DynamicBuilder[any]) *DynamicWidget {
	return dynamicWidget(list, f, true, true)
}

func DynamicVR[T any](list []T, f DynamicBuilder[any]) *DynamicWidget {
	return dynamicWidget(list, f, false, true)
}

func DynamicHC[T any](list []T, f DynamicBuilder[any]) *DynamicWidget {
	return dynamicWidget(list, f, true, false)
}

func DynamicVC[T any](list []T, f DynamicBuilder[any]) *DynamicWidget {
	return dynamicWidget(list, f, false, false)
}

type DynamicBuilder[T any] func(i int, elem T) []giu.Widget
type dynamicGetterFunc[T any] func(i int) T

func dynamicWidget[T any](list []T, f DynamicBuilder[any], isHorizontal bool, hasRows bool) *DynamicWidget {
	return &DynamicWidget{
		isHorizontal: isHorizontal,
		hasRows:      hasRows,
		builder:      f,
		getter: func(i int) interface{} {
			if i < 0 || i >= len(list) {
				return nil
			}
			return list[i]
		},
	}
}

func (d *DynamicWidget) Build() {
	widgets := []giu.Widget{}
	for i := 0; ; i++ {
		elem := d.getter(i)
		if elem == nil {
			break
		}
		group := d.builder(i, elem)
		if d.hasRows {
			widgets = append(widgets, giu.Row(group...))
		} else {
			widgets = append(widgets, giu.Column(group...))
		}
	}

	if d.isHorizontal {
		giu.Row(widgets...).Build()
	} else {
		giu.Column(widgets...).Build()
	}
}

func loadmessages() []messagestruc {
	var URL string = api + "/getmessages"
	var page2 string = strconv.Itoa(page)
	var messageList2 []messagestruc
	data := map[string][]string{
		"password": {password},
		"user1":    {user},
		"user2":    {sendingto},
		"page":     {page2},
	}
	response, err := http.PostForm(URL, url.Values(data))

	if err != nil {
		return []messagestruc{messagestruc{0, "Couldn't connect to server", "SMessenger", "", ""}}
	}

	if response.StatusCode != 200 {
		text, _ := ioutil.ReadAll(response.Body)
		resp := string(text)
		return []messagestruc{messagestruc{0, resp, "SMessenger", "", ""}}
	}

	totalpages, err = strconv.Atoi(response.Header.Get("totalpages"))
	if err != nil {
		return []messagestruc{messagestruc{0, "Internal server error", "SMessenger", "", ""}}
	}

	dec := json.NewDecoder(response.Body)
	err = dec.Decode(&messageList2)
	if err != nil {
		return []messagestruc{messagestruc{0, "Internal server error", "SMessenger", "", ""}}
	}
	return messageList2
}

func contactBuilder(i int, elem interface{}) []giu.Widget {
	return []giu.Widget{
		g.Button(elem.(string)).Size(120, 30).OnClick(func() {
			sendingto = elem.(string)
			page = 1
			messageList = loadmessages()
			minid = messageList[len(messageList)-1].Id
			go getcurrentmessages()
		}),
	}
}

func messageBuilder(i int, elem interface{}) []giu.Widget {
	e := elem.(messagestruc)
	if e.Message == "" {
		return []giu.Widget{}
	}
	return []giu.Widget{
		g.Row(g.Label(e.From), g.Column(g.Dummy(0, 2), g.Style().SetFontSize(11).To(g.Label(e.Time)))),
		g.Label(e.Message).Wrapped(true),
		g.Dummy(0, 10),
	}
}

func getcurrentmessages() {
	sendingbozo := sendingto
	URL := "wss://goapi.sophuwu.site/smessenger/messageupdate"
	ws, err := websocket.Dial(URL, "", "https://goapi.sophuwu.site")
	if err != nil {
		crash()
	}
	ToFromPassword := [3]string{sendingbozo, user, password}
	sending, err := json.Marshal(ToFromPassword)
	if err != nil {
		crash()
	}
	_, err = ws.Write(sending)
	if err != nil {
		crash()
	}
	var msg = make([]byte, 512)
	var n int
	var receive messagestruc
	time.Sleep(500 * time.Millisecond)
	for sendingbozo == sendingto {
		if n, err = ws.Read(msg); err != nil {
			break
		}
		err = json.Unmarshal(msg[:n], &receive)
		if err != nil {
			_ = ws.Close()
			crash()
		}
		if receive.Id == 0 {
			continue
		}
		tmpmessagelist := []messagestruc{receive}
		messageList = append(tmpmessagelist, messageList...)
		g.Update()
	}
	_ = ws.Close()
}


func crash() {
	wnd.Close()
	time.Sleep(time.Second)
	wnd = g.NewMasterWindow("An Oof Has Occurred", 200, 69, g.MasterWindowFlagsFloating+g.MasterWindowFlagsNotResizable)
	go wnd.Run(func() {
		g.SingleWindow().Layout(
			g.Label("SMessenger has stopped."),
			g.Label("The program is having difficulties requesting important information from the server.").Wrapped(true),
			g.Label("Please try again later."),
			g.Label("This window will close automatically in 10 seconds."),
		)
	})
	time.Sleep(10 * time.Second)
	os.Exit(1)
}

func checkifuserexists(username string) bool {
	var exists bool
	var URL string = api + "/checkifuserexists"
	data := map[string][]string{
		"username": {username},
	}
	resp, err := http.PostForm(URL, url.Values(data))
	if err != nil || resp.StatusCode != 200 {
		crash()
	}
	dec := json.NewDecoder(resp.Body)
	err = dec.Decode(&exists)
	if err != nil {
		fmt.Println(err)
	}
	return exists
}

func newmessagefunc() {
	if addcontact == "" || addcontact == user || len(addcontact) > 15 {
		addcontact = ""
		g.Update()
		return
	}

	for _, contact := range contactList {
		if contact == addcontact {
			addcontact = ""
			g.Update()
			return
		}
	}

	if !checkifuserexists(addcontact) {
		addcontact = ""
		g.Update()
		return
	}

	contactList = append(contactList, addcontact)
	addcontact = ""
	g.Update()
}

func sendmessagefunc() {
	if sendmessage == "" || sendingto == "" || len(sendmessage) > 200 || len(sendingto) > 15 || sendingto == user || !checkifuserexists(sendingto) {
		messageList = []messagestruc{messagestruc{0, "Error sending message", "SMessenger", "", ""}}
		g.Update()
		return
	}

	var URL string = api + "/sendmessage"
	data := map[string][]string{
		"password": {password},
		"from":     {user},
		"to":       {sendingto},
		"message":  {sendmessage},
	}
	response, err := http.PostForm(URL, url.Values(data))
	if err != nil {
		messageList = []messagestruc{messagestruc{0, "Couldn't connect to server", "SMessenger", "", ""}}
		g.Update()
		return
	}
	if response.StatusCode != 200 {
		text, _ := ioutil.ReadAll(response.Body)
		resp := string(text)
		messageList = []messagestruc{messagestruc{0, resp, "SMessenger", "", ""}}
		g.Update()
		return
	}
	messageList = append([]messagestruc{messagestruc{0, sendmessage, user, "", time.Now().Format("2006-01-02 15:04:05")}}, messageList...)
	sendmessage = ""
	g.Update()

}

func loadmoremessages() {
	page = page + 1
	if page > totalpages {
		return
	}
	messageList2 := loadmessages()
	for _, v := range messageList2 {
		if v.Id < minid {
			messageList = append(messageList, v)
		}
	}
	minid = messageList[len(messageList)-1].Id
	g.Update()

}

func loop() {
	g.SingleWindow().Layout(
		g.Row(
			g.Child().Layout(
				g.Column( //contact list
					g.Dummy(0, 0),
					g.Label("Contacts"),
					g.InputText(&addcontact).Size(120),
					g.Button("New Contact").Size(120, 30).OnClick(func() {
						go newmessagefunc()
					}),
					DynamicVR(contactList, contactBuilder),
				),
			).Size(135, 383),
			g.Child().Layout(
				g.Column( //message area
					g.Label("Messages to "+sendingto),
					g.Row(g.InputText(&sendmessage).Size(480), g.Button("Send").Size(65, 22).OnClick(func() {
						go sendmessagefunc()
					})),
					DynamicVC(messageList, messageBuilder),
					g.Row(
						g.Dummy(165, 0),
						g.Button("Load More Messages").Size(200, 30).OnClick(func() {
							go loadmoremessages()
						}),
					),
				),
			),
		),
	)
}

func getcontacts() {
	var URL string = api + "/getcontacts"
	data := map[string][]string{
		"password": {password},
		"username": {user},
	}
	response, err := http.PostForm(URL, url.Values(data))
	if err != nil {
		messageList = []messagestruc{messagestruc{0, "Couldn't connect to server", "SMessenger", "", ""}}
		g.Update()
		return
	}
	if response.StatusCode != 200 {
		text, _ := ioutil.ReadAll(response.Body)
		resp := string(text)
		messageList = []messagestruc{messagestruc{0, resp, "SMessenger", "", ""}}
		g.Update()
		return
	}
	dec := json.NewDecoder(response.Body)
	var contacts []string
	err = dec.Decode(&contacts)
	if err != nil {
		messageList = []messagestruc{messagestruc{0, "Error getting contacts", "SMessenger", "", ""}}
		g.Update()
		return
	}
	contactList = contacts
}

func login() {
	g.SingleWindow().Layout(
		g.Row(
			g.Column(
				g.Label("Login"),
				g.Dummy(0, 0),
				g.Label("Username"),
				g.InputText(&loginuser).Size(120),
				g.Label("Password"),
				g.InputText(&loginpassword).Size(120),
				g.Button("Login").Size(120, 30).OnClick(func() {
					if loginuser == "" || loginpassword == "" {
						errormessage = "Username or password is empty"
						g.Update()
						return
					} else if len(loginuser) > 15 || len(loginpassword) > 15 {
						errormessage = "Username or password is too long"
						g.Update()
						return
					} else if !checkifuserexists(loginuser) {
						errormessage = "Username does not exist"
						g.Update()
						return
					}
					URL := api + "/login"
					data := map[string][]string{
						"password": {loginpassword},
						"username": {loginuser},
					}
					resp, err := http.PostForm(URL, url.Values(data))
					if err != nil {
						errormessage = "Couldn't connect to server"
						g.Update()
						return
					}
					if resp.StatusCode != 200 {
						text2, _ := ioutil.ReadAll(resp.Body)
						text := string(text2)
						errormessage = text
						g.Update()
						return
					}
					text2, _ := ioutil.ReadAll(resp.Body)
					text := string(text2)
					if text != "none" {
						errormessage = text
						g.Update()
						return
					}
					user = loginuser
					password = loginpassword
					wnd.Close()
				}),
			),
			g.Dummy(50, 0),
			g.Column(
				g.Label("Register"),
				g.Dummy(0, 0),
				g.Label("Username"),
				g.InputText(&registeruser).Size(120),
				g.Label("Password"),
				g.InputText(&registerpassword).Size(120),
				g.Button("Register").Size(120, 30).OnClick(func() {
					if registeruser == "" || registerpassword == "" {
						errormessage = "Username or password is empty"
						g.Update()
						return
					} else if len(registeruser) > 15 || len(registerpassword) > 15 {
						errormessage = "Username or password is too long"
						g.Update()
						return
					} else if checkifuserexists(registeruser) {
						errormessage = "Username already exists"
						g.Update()
						return
					}
					URL := api + "/registeruser"
					data := map[string][]string{
						"password": {registerpassword},
						"username": {registeruser},
					}
					resp, err := http.PostForm(URL, url.Values(data))
					if err != nil {
						errormessage = "Couldn't connect to server"
						g.Update()
						return
					}
					text, _ := ioutil.ReadAll(resp.Body)
					response := string(text)
					if response != "none\n" {
						errormessage = response
						g.Update()
						return
					}
					user = registeruser
					password = registerpassword
					wnd.Close()
				}),
			),
		),
		g.Row(g.Button("Close").OnClick(func() {
			wnd.Close()
		}), g.Dummy(5, 0), g.Label(errormessage),
		),
	)
}

func run() {
	wnd = g.NewMasterWindow("SMessanger", 325, 185, g.MasterWindowFlagsNotResizable)
	wnd.Run(login)
	if user == "" || password == "" {
		return
	}
	getcontacts()
	wnd = g.NewMasterWindow("SMessanger", 745, 400, g.MasterWindowFlagsNotResizable)
	wnd.Run(loop)

}

func checkversion() bool {
	resp, err := http.Get(versionserver)
	if err != nil {
		window := g.NewMasterWindow("SMessanger", 210, 135, g.MasterWindowFlagsFrameless)
		window.Run(func() {
			g.SingleWindow().Layout(
				g.Label("SMessanger:"),
				g.Dummy(0, 1),
				g.Label("Error connecting to server."),
				g.Dummy(0, 1),
				g.Label("Please check your internet connection or try again later.").Wrapped(true),
				g.Dummy(0, 1),
				g.Button("Close").OnClick(func() {
					window.Close()
				}),
			)
		})
		return false
	}
	text, _ := ioutil.ReadAll(resp.Body)
	response := string(text)
	if response != version {
		window := g.NewMasterWindow("SMessanger", 300, 110, g.MasterWindowFlagsFrameless)
		window.Run(func() {
			g.SingleWindow().Layout(
				g.Label("You are using an outdated version: "+version),
				g.Label("Please update to the latest version: "+response),
				g.Dummy(0, 1),
				g.Style().SetColor(g.StyleColorText, color.RGBA{R: 100, G: 100, B: 255, A: 255}).To(
					g.Label(updateurl),
				),
				g.Dummy(0, 1),
				g.Row(
					g.Dummy(65, 0),
					g.Button("open dowload page").OnClick(func() {
						g.OpenURL(updateurl)
						window.Close()
					}),
				),
			)
		})
		return false
	}
	return true
}

func main() {
	if len(os.Args) == 1 && !checkversion() {
		return
	}
	run()
}
