package main

import (
	"image/color"
	"io/ioutil"
	"net/http"
	"strings"
	"time"

	g "github.com/AllenDang/giu"
)

var (
	version     string = "2.2"
	output      string
	input       string
	loopstop    bool = false
	funcrunning bool = false
)

func stoploop() {
	loopstop = true
}

func clearoutput() {
	if funcrunning {
		return
	}
	funcrunning = true
	for range output {
		if loopstop {
			break
		}
		output = output[:len(output)-1]
		g.Update()
		time.Sleep(20 * time.Millisecond)
	}
	funcrunning = false
	loopstop = false
}

func askmodel(input2 string, model string) {
	if funcrunning {
		return
	}
	funcrunning = true
	input3 := [5]string{"_", "_", "_", "_", "_"}

	var tmp = strings.Split(input2, " ")

	var x int = len(tmp)
	if x >= 5 {
		input3 = [5]string{tmp[x-5], tmp[x-4], tmp[x-3], tmp[x-2], tmp[x-1]}
	} else if x == 4 {
		input3 = [5]string{"_", tmp[x-4], tmp[x-3], tmp[x-2], tmp[x-1]}
	} else if x == 3 {
		input3 = [5]string{"_", "_", tmp[x-3], tmp[x-2], tmp[x-1]}
	} else if x == 2 {
		input3 = [5]string{"_", "_", "_", tmp[x-2], tmp[x-1]}
	} else if x == 1 {
		input3 = [5]string{"_", "_", "_", "_", tmp[x-1]}
	}
	var url string = "https://api.sophuwu.site/ai/" + model + "/"

	var url1 string
	var response string
	var sleeptime int = 0
	loopstop = false

	output = ""
	for _, r := range input2 {
		if loopstop {
			break
		}
		output = output + string(r)
		g.Update()
		time.Sleep(40 * time.Millisecond)
	}

	for i := 0; i < 30; i++ {

		if loopstop {
			break
		}
		if model == "jessica" {
			url1 = url + input3[0] + "_" + input3[1] + "_" + input3[2] + "_" + input3[3] + "_" + input3[4]
		} else {
			url1 = url + input3[2] + "_" + input3[3] + "_" + input3[4]
		}
		if url1 == url+"_____" {
			break
		}
		resp, err := http.Get(url1)
		if err != nil {
			output = "HTTP connection error."
			funcrunning = false
			loopstop = false
			g.Update()
			return
		}
		text, _ := ioutil.ReadAll(resp.Body)
		response = string(text)

		input3 = [5]string{input3[1], input3[2], input3[3], input3[4], response}
		output = output + " "
		if len(response) > 0 {
			sleeptime = 250 / len(response)
		} else {
			sleeptime = 0
		}
		for _, r := range response {
			if loopstop {
				break
			}
			output = output + string(r)
			g.Update()
			time.Sleep(time.Duration(sleeptime) * time.Millisecond)
		}

		if strings.Contains(response, "ERROR") || response == "END" {
			break
		}
	}
	funcrunning = false
	loopstop = false
}

func loop() {
	g.SingleWindow().Layout(
		g.Label("Sophie's AI autocomplete, enter up to 5 words:"),
		g.InputText(&input).Size(390),
		g.Row(
			g.Label("Ask Model:"),
			g.RangeBuilder("Buttons", []interface{}{"ben", "jake", "jessica"}, func(i int, v interface{}) g.Widget {
				model := v.(string)
				return g.Button(model).OnClick(func() {
					go askmodel(input, model)
				})
			}),
			g.Button("Clear").OnClick(func() {
				go clearoutput()
			}),
			g.Button("Stop").OnClick(func() {
				go stoploop()
			}),
		),
		g.Label(output).Wrapped(true),
	)
}

func main() {
	var url string = "https://api.sophuwu.site/software/version/sophai"
	resp, err := http.Get(url)
	if err != nil {
		wnd := g.NewMasterWindow("SophAI", 210, 75, g.MasterWindowFlagsNotResizable)
		wnd.Run(func() {
			g.SingleWindow().Layout(
				g.Label("Error connecting to server."),
				g.Dummy(0, 1),
				g.Label("Please check your internet connection or try again later.").Wrapped(true),
			)
		})
	} else {
		text, _ := ioutil.ReadAll(resp.Body)
		response := string(text)
		if response == version {
			wnd := g.NewMasterWindow("SophAI", 410, 190, g.MasterWindowFlagsNotResizable)
			wnd.Run(loop)
		} else {
			wnd := g.NewMasterWindow("SophAI", 270, 110, g.MasterWindowFlagsNotResizable)
			wnd.Run(func() {
				g.SingleWindow().Layout(
					g.Label("You are using an outdated version: "+version),
					g.Label("Please update to the latest version: "+response),
					g.Dummy(0, 1),
					g.Style().SetColor(g.StyleColorText, color.RGBA{R: 100, G: 100, B: 255, A: 255}).To(
						g.Label("https://sophuwu.site/software/sophai"),
					),
					g.Dummy(0, 1),
					g.Row(
						g.Dummy(50, 0),
						g.Button("open dowload page").OnClick(func() {
							g.OpenURL("https://sophuwu.site/software/sophai")
						}),
					),
				)
			})
		}
	}
}
